﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

//Header (7 bytes)
//1 byte 	Version
//1 byte 	Colour Depth
//			    0 – 24 bit colour (RGB)
//			    1 – 8 bit colour (CLUT)
//			    2 – 1 bit monochrome

//2 Bytes	Image width (px)
//2 Bytes	Image height (px)
//1 Byte	Compression
//			    0 – none
//			    1 - RLE
//                  1 byte data
//                  2 bytes byte count
//              2 - LZW  Buggy!!!!!!!!!!!
//                  12 bit
//Total Data N Bytes
//N Bytes	Image data


public class clsMog
{

    private string lFileName;
    private Byte lVersion = 1;
    private Byte lColourResolution;
    private Int32 lImageWidth;
    private Int32 lImageHeight;
    private Byte lCompression;
    private Int32 lNoOfBytes;
    private List<Byte> lImageData = new List<byte>();
    private clsFileIO IO = new clsFileIO();
    private clsBaseConvert HX = new clsBaseConvert();

    public clsMog()
    {
        //
        // TODO: Add constructor logic here
        //
    }

    private string BitString
    {
        get
        {
            clsBaseConvert Bin = new clsBaseConvert();
            return Bin.BytesToBinString(lImageData);
        }
    }

    public List<Byte> ImageData
    {
        get
        {
            return lImageData;
        }
        set
        {
            lImageData = value;
        }
    }

    public Byte Version
    {
        get
        {
            return lVersion;
        }
        set
        {
            lVersion = value;
        }
    }

    public Int32 ImageHeight
    {
        get
        {
            return lImageHeight;
        }
        set
        {
            lImageHeight = value;
        }
    }


    public Int32 ImageWidth
    {
        get
        {
            return lImageWidth;
        }
        set
        {
            lImageWidth = value;
        }
    }

    public string FileName
    {
        get
        {
            return lFileName;
        }
        set
        {
            lFileName = value;
        }
    }

    public Byte Compression
    {
        get
        {
            return lCompression;
        }
        set
        {
            lCompression = value;
        }
    }

    public Byte ColourResolution
    {
        get
        {
            return lColourResolution;
        }
        set
        {
            lColourResolution = value;
        }
    }

    public List<Byte> GetPixelData(Int32 Index)
    {
        List<Byte> pixelData = new List<Byte>();
        if (lColourResolution == 0)
        {
            pixelData.Add(lImageData[Index]);
            pixelData.Add(lImageData[Index + 1]);
            pixelData.Add(lImageData[Index + 2]);
        }
        if (lColourResolution == 1)
        {
            pixelData.Add(lImageData[Index]);
        }
        if (lColourResolution == 2)
        {
            Byte SomeBit = Convert.ToByte(BitString.Substring(Index, 1));
            pixelData.Add(SomeBit);
        }
        return pixelData;
    }

    public void Save()
    {
        List<byte> Bytes = new List<byte>();
        List<byte> bodyData = new List<byte>();
        IO.OpenFileWrite(lFileName);
        IO.WriteByte(lVersion);
        IO.WriteByte(lColourResolution);
        Bytes = HX.GetDecBytes(lImageWidth, 2);
        IO.WriteBytes(Bytes);
        Bytes = HX.GetDecBytes(lImageHeight, 2);
        IO.WriteBytes(Bytes);
        IO.WriteByte(lCompression);
        bodyData = BodyData;
        lNoOfBytes = bodyData.Count;
        Bytes = HX.GetDecBytes(lNoOfBytes, 2);
        IO.WriteBytes(Bytes);
        IO.WriteBytes(bodyData);
        IO.Close();
    }

    private List<Byte> BodyData
    {
        get
        {
            List<Byte> bodyData = new List<Byte>();
            if (lColourResolution == 2)
            {
                bodyData = RGB2Mono(lImageData);
            }
            if (lColourResolution == 1)
            {
                bodyData = RGBToCLUT(lImageData);
            }
            if (lColourResolution == 0)
            {
                bodyData = lImageData;
            }
            if (lCompression == 1)
            {
                clsCompression Comp = new clsCompression();
                bodyData = Comp.RLECompress(bodyData);
            }
            if (lCompression == 2)
            {
                clsCompression Comp = new clsCompression();
                bodyData = Comp.LZWCompress(bodyData);
            }
            return bodyData;
        }
    }

    private List<Byte> RGB2Mono(List<Byte> RGB)
    {
        Int32 RGBRed;
        Int32 RGBGreen;
        Int32 RGBBlue;
        Int32 FullColour;
        String BITS = "";
        clsBaseConvert Bin = new clsBaseConvert();
        List<Byte> MonoData = new List<Byte>();
        for (Int32 Counter = 0; Counter < RGB.Count; Counter += 3)
        {
            //#FFFFFF white #000000 black
            RGBRed = RGB[Counter];
            RGBGreen = RGB[Counter + 1];
            RGBBlue = RGB[Counter + 2];
            FullColour = (RGBRed * 65536) + (RGBGreen * 256) + RGBBlue;
            if (FullColour < 8388607)
            {
                BITS += "1";
            }
            else
            {
                BITS += "0";
            }
        }
        MonoData = Bin.BinStringToBytes(BITS);
        return MonoData;
    }

    private List<Byte> RGBToCLUT(List<Byte> SomeBytes)
    {
        Int32 Index = 0;
        List<Byte> PixelData = new List<byte>();
        List<clsRGBPixel> clut = new List<clsRGBPixel>();
        clsRGBPixel Pixel = new clsRGBPixel();
        for (Int32 Counter = 0; Counter < SomeBytes.Count; Counter += 3)
        {
            Pixel = new clsRGBPixel();
            Pixel.Red = SomeBytes[Counter];
            Pixel.Green = SomeBytes[Counter + 1];
            Pixel.Blue = SomeBytes[Counter + 2];
            //Index =CLUT.IndexOf(Pixel);
            if (PixelIndexInCLUT(Pixel, clut) == -1)
            {
                clut.Add(Pixel);
            }
            Index = PixelIndexInCLUT(Pixel, clut);
            PixelData.Add(Convert.ToByte(Index));
        }
        for (Int32 Counter = 0; Counter < clut.Count; Counter++)
        {
            PixelData.Add(Convert.ToByte(clut[Counter].Red));
            PixelData.Add(Convert.ToByte(clut[Counter].Green));
            PixelData.Add(Convert.ToByte(clut[Counter].Blue));
        }
        return PixelData;
    }

    private Int32 PixelIndexInCLUT(clsRGBPixel Pixel, List<clsRGBPixel> clut)
    {
        Int32 Index = -1;
        Int32 Counter = 0;
        while (Index == -1 & Counter < clut.Count)
        {
            if (clut[Counter].Red == Pixel.Red & clut[Counter].Green == Pixel.Green & clut[Counter].Blue == Pixel.Blue)
            {
                Index = Counter;
            }
            else
            {
                Counter++;
            }
        }
        return Index;
    }

    public clsRGBPixel PixelFromCLUT(Int32 Index)
    {
        clsRGBPixel PixelData = new clsRGBPixel();
        PixelData = CLUT[Index];
        return PixelData;
    }

    private List<clsRGBPixel> CLUT
    {
        get
        {
            Int32 ImageDataEnd = lImageHeight * lImageWidth;
            List<clsRGBPixel> clut = new List<clsRGBPixel>();
            for (Int32 Counter = ImageDataEnd; Counter < lImageData.Count; Counter += 3)
            {
                clsRGBPixel Pixel = new clsRGBPixel();
                Pixel.Red = lImageData[Counter];
                Pixel.Green = lImageData[Counter + 1];
                Pixel.Blue = lImageData[Counter + 2];
                clut.Add(Pixel);
            }
            return clut;
        }
    }
}

